/*****
Récupération du XHR
*****/
function getXhr()
{
	var xhr = null; 
	if(window.XMLHttpRequest) // Firefox et autres
	   xhr = new XMLHttpRequest(); 
	else if(window.ActiveXObject)
	{ // Internet Explorer 
		try 
		{
			xhr = new ActiveXObject("Msxml2.XMLHTTP");
		} 
		catch (e) 
		{
			xhr = new ActiveXObject("Microsoft.XMLHTTP");
		}
	}
	else 
	{ // XMLHttpRequest non supporté par le navigateur  
	   xhr = false; 
	} 
	
	return xhr
}

/*****
Affichage du formulaire d'ajout de lien au guide dans un message  
*****/
function bbcodecheckajoutguide(quoi,idlien,lien)
{
	// Alertes pour tester l'envoi des bonnes variables 
	// alert('code du span pour le formulaire : 'quoi); 
	// alert('lien : '+lien); 
	// alert('identifiant du lien : '+idlien); 

	var xhr = getXhr(); 
	// On définit ce qu'on va faire quand on aura la réponse
	xhr.onreadystatechange = function()
	{
		// On ne fait quelque chose que si on a tout reçu et que le serveur est ok
		if(xhr.readyState == 4 && xhr.status == 200)
		{ 			
			document.getElementById(quoi).innerHTML = 'code retour : '+xhr.responseText+''; 
		
			// Non identifié 
			if(xhr.responseText == '-1')
			{
				document.getElementById(quoi).innerHTML = 'Ce lien n\'existe pas dans notre guide. Identifiez vous si vous souhaitez l\'ajouter !';
			} 
			
			// Paramètres manquants 
			else if(xhr.responseText == '-2')
			{
				alert('Paramètres manquants en entrée.'); 
			} 
			
			// Mauvais paramètres 
			else if(xhr.responseText == '-3')
			{
				alert('Mauvais paramètres en entrée.'); 
			} 
			
			// Lien inconnu 
			else if(xhr.responseText == '0')
			{
				document.getElementById(quoi).innerHTML = '<form action="new_topic.php?id=5" method="post">'+idlien+'<input type="submit" value="Go"></form>'; 
			} 
			
			// Lien déjà enregistré 
			else if(xhr.responseText > '0')
			{
				document.getElementById(quoi).innerHTML = ''+xhr.responseText+' message(s) à propos de cette adresse'; 
			} 
			
			// Erreur non identifiée 
			else
			{
				alert('erreur non identifiée : '+xhr.responseText+'');
			}
		} 
	}
	xhr.open("GET","check_ajoutlienguide.php?idurl="+idlien+"&url="+lien+"",true);
	xhr.send(null); 
}

/*****
Affichage du nombre de personnes en ligne et du nb de messages 
*****/
function nbpaxenligne()
{
	var xhr = getXhr(); 
	// On définit ce qu'on va faire quand on aura la réponse
	xhr.onreadystatechange = function()
	{
		// On ne fait quelque chose que si on a tout reçu et que le serveur est ok
		if(xhr.readyState == 4 && xhr.status == 200)
		{
			if(trim(xhr.responseText) != "")
			{
				var patternNbpaxOpen = "*"; 
				var patternNbpaxClose = "*";  
				var patternNbMsgOpen = "*"; 
				var patternNbMsgClose = "*"; 
			
				var messagewhos = xhr.responseText.replace(patternNbpaxOpen, "<a class=\"lien_menu\" href=\"#\" onclick=\"showWhosFromLink(); return false;\" onMouseOut=\"hideWhosFromLink(); return false;\">"); 
				messagewhos = messagewhos.replace(patternNbpaxClose, "</a>"); 
				messagewhos = messagewhos.replace(patternNbMsgOpen, "<a class=\"lien_menu\" href=\"boite_reception_mp.php\">"); 
				messagewhos = messagewhos.replace(patternNbMsgClose, "</a>"); 
				document.getElementById('en_ce_moment').innerHTML=""+messagewhos+""; 
			} 
			
			// setTimeout("nbpaxenligne()", 120000);
		}
	}
	// xhr.open("GET","en_ce_moment.php",true);
	// xhr.send(null);
}

/*****
Envoi d'un message privé 
*****/
function envoimp()
{ 
	// Vérification des champs obligatoires 
	if(!checkform(document.forms[2])) 
	{
		return false; 
	}
	
	// Vérification de l'existence de l'utilisateur saisi 
	var ze_user = document.getElementById('requiredle_destinataire_du_message_prive').value; 
	var xhr = getXhr(); 
	
	// AJAX : On définit ce qu'on va faire quand on aura la réponse
	xhr.onreadystatechange = function()
	{ 
		// AJAX : On ne fait quelque chose que si on a tout reçu et que le serveur est ok
		if(xhr.readyState == 4 && xhr.status == 200)
		{			
			if(xhr.responseText == 'non_identifie')
			{
				alert('Vous ne pouvez pas envoyer de message sans être identifié.\n Merci de vous connecter et de recommencer.');
				return false; 
			} 
			
			else if(xhr.responseText == '')
			{
				alert('Aucune réponse reçue.\n Votre message n\a pas été envoyé.');
				return false; 
			} 
			
			else if(xhr.responseText == 'non_transmis')
			{
				alert('Erreur : Nom du destinataire non transmis. Message non envoyé.'); 
				return false; 
			}
			
			else if(xhr.responseText == 'banni')
			{
				alert('Vous êtes banni et ne pouvez envoyer de message privé.\n Contactez un administrateur pour obtenir plus d\'information.');
				document.location.href='logout.php'; 
				return false; 
			} 
			
			else if(xhr.responseText == 'non_autorise')
			{
				alert('Vous n\'êtes pas autorisé à envoyer de message privé, sauf à un administrateur.\n Contactez un administrateur pour obtenir plus d\'information.');
				return false; 
			} 
			
			else if(xhr.responseText == 'non_trouve')
			{
				alert('Le destinataire saisi n\'existe pas.\n Votre message n\'a pas été envoyé.');
				return false; 
			} 
			
			else if(xhr.responseText == 'dest_banni') 
			{ 
				alert('Le destinataire saisi est banni.\n Vous ne pouvez pas lui envoyer de message.\n Envoi annulé.');
				return false; 
			} 
			
			else if(xhr.responseText == 'dest_desactive') 
			{ 
				alert('Le destinataire saisi a désactivé son compte.\n Vous ne pouvez pas lui envoyer de message.\n Envoi annulé. ');
				return false; 
			} 			
			
			else if(xhr.responseText == 'dest_non_autorise') 
			{ 
				alert('Le destinataire saisi n\'est pas autorisé\n à envoyer ou recevoir des messages privés.\n Envoi annulé.');
				return false; 
			} 			
			
			else if(xhr.responseText == 'dest_is_exp') 
			{ 
				alert('Euuuuh... comment dire...\n Pour s\'envoyer des messages à soi-même il existe :\n - les bloc-notes,\n - les ardoises et autres tableaux,\n - la pensée (pas mal ça),\n - tout ce que je n\'ai pas encore listé ici.\n Alors pourquoi s\'envoyer des messages privés à soi-même sur Blork ?\n Envoi annulé.');
				return false; 
			} 
			
			else if(xhr.responseText == 'ok')
			{
				document.forms[2].submit(); 
			} 
			
			else 
			{
				alert('Erreur non identifiée : '+xhr.responseText+'.\n Votre message n\'a pas été envoyé.');
				return false; 
			}
		}
	}
	xhr.open("GET","check_envoi_mp.php?user="+ze_user+"",true);
	xhr.send(null); 
} 

/*****
Citation d'un message privé 
*****/
function encodeutf(string)
{
		string = string.replace(/\r\n/g,"\n");
		var utftext = "";
 
		for (var n = 0; n < string.length; n++) {
 
			var c = string.charCodeAt(n);
 
			if (c < 128) {
				utftext += String.fromCharCode(c);
			}
			else if((c > 127) && (c < 2048)) {
				utftext += String.fromCharCode((c >> 6) | 192);
				utftext += String.fromCharCode((c & 63) | 128);
			}
			else {
				utftext += String.fromCharCode((c >> 12) | 224);
				utftext += String.fromCharCode(((c >> 6) & 63) | 128);
				utftext += String.fromCharCode((c & 63) | 128);
			}
 
		}
 
		return utftext;
}

function replymp(id_mp)
{
	var xhr = getXhr(); 
	// AJAX : On définit ce qu'on va faire quand on aura la réponse
	xhr.onreadystatechange = function()
	{ 
		// AJAX : On ne fait quelque chose que si on a tout reçu et que le serveur est ok
		if(xhr.readyState == 4 && xhr.status == 200)
		{
			// On réencode la réponse en UTF-8 car pour éviter des problèmes d'encodage PHP la transforme en ISO
			document.getElementById('requiredvotre_message_prive').value = unescape(encodeutf(xhr.responseText)); 
		}
	} 
	
	xhr.open("GET","reply_mp.php?id="+id_mp+"",true);
	xhr.send(null); 
} 

/*****
Envoi par email d'un message privé
*****/
function emailmp(id_mp)
{
	var xhr = getXhr()
	// AJAX : On définit ce qu'on va faire quand on aura la réponse
	xhr.onreadystatechange = function()
	{ 
		// AJAX : On ne fait quelque chose que si on a tout reçu et que le serveur est ok
		if(xhr.readyState == 4 && xhr.status == 200)
		{			
			if(xhr.responseText == '')
			{
				alert('Aucune réponse reçue.\n La copie du message n\'a pas été envoyée.');
				return false; 
			} 
			
			else if(xhr.responseText == 'non_transmis')
			{
				alert('Erreur : Paramètres transmis incorrects.\n Message non envoyé.'); 
				return false; 
			} 
			
			else if(xhr.responseText == 'non_recuperable')
			{
				alert('Contenu du message non récupérable.\n Message non envoyé.'); 
				return false; 
			} 
			
			else if(xhr.responseText == 'email_empty')
			{
				alert('Votre adresse email n\'est pas renseignée dans votre profil.\n Message non envoyé.'); 
				return false; 
			} 
			
			else if(trim(xhr.responseText) == 'envoiok')
			{
				alert('Une copie du message a bien été envoyée\nà votre adresse email.'); 
				return false; 
			} 
			
			else 
			{
				alert('Erreur non identifiée : '+xhr.responseText+'.\n La copie du message n\'a pas été envoyée.');
				return false; 
			}
		}
	} 
	
	xhr.open("GET","email_mp.php?id="+id_mp+"",true);
	xhr.send(null); 
} 

/*****
Suppression d'un message privé 
*****/
function deletemp(id_mp,token_mp)
{
	if(confirm('Ce message sera supprimé définitivement.\n Confirmez vous cette action ?') == false)
	{
		alert('Suppression du message annulée !');
		return false; 
	} 

	var xhr = getXhr()
	// AJAX : On définit ce qu'on va faire quand on aura la réponse
	xhr.onreadystatechange = function()
	{ 
		// AJAX : On ne fait quelque chose que si on a tout reçu et que le serveur est ok
		if(xhr.readyState == 4 && xhr.status == 200)
		{			
			if(xhr.responseText == '')
			{
				alert('Aucune réponse reçue.\n Message non supprimé.');
				return false; 
			} 
			
			else if(xhr.responseText == 'non_transmis')
			{
				alert('Erreur : Paramètres transmis incorrects.\n Message non supprimé.'); 
				return false; 
			} 
			
			else if(xhr.responseText == 'non_recuperable')
			{
				alert('Message non récupérable.\n Message non supprimé.'); 
				return false; 
			} 
			
			else if(xhr.responseText == 'ok')
			{
				document.location.href = 'boite_reception_mp.php';
				return false; 
			} 
			
			else 
			{
				alert('Erreur non identifiée : '+xhr.responseText+'.\n Le message n\'a pas été supprimé.');
				return false; 
			}
		}
	} 
	
	xhr.open("GET","delete_mp.php?id="+id_mp+"&token="+token_mp+"",true);
	xhr.send(null); 
} 